/*
Opleiding	: Basisvaardigheden SQL Query's schrijven van SQLTeam.NL
Module		: Gegevens selecteren, filteren en sorteren
*/

/* Opbouw en structuur van een query */
SELECT
*
FROM dbo.Posts -- draait in 1m45s

/* Gebruik van de TOP functie */
SELECT TOP 100
*
FROM dbo.Posts

/*
	Velden selecteren (icm aliassen)
	Tabel alias uitleggen
	Velden uitleggen (denk aan komma)
	Formatteren van query's
	Commentaarregels en blokken
*/
SELECT TOP 100
	p.Id,
	p.CreationDate,
	p.Score,
	p.Title,
	p.Body
FROM dbo.Posts p


/* Filteren van data met WHERE functie */
SELECT TOP 100
	p.Id			AS PostId,			-- 'AS PostID' is een veldalias (meer informatie aan het eind van dit script)
	p.CreationDate	AS AanmaakDatum,
	p.Score			AS Score,
	p.Title			AS Titel,
	p.Body			AS PostInhoud
FROM dbo.Posts p
WHERE p.Score > 100 -- zonder '', omdat Score een integer is (LET OP: tabel alias!)

-- Maar (met nvarchar / varchar veld = tekstveld) ...
SELECT TOP 100
	p.Id					AS PostId,
	p.CreationDate			AS AanmaakDatum,
	p.Score					AS Score,
	p.Title					AS Titel,
	p.Body					AS PostInhoud,
	p.LastEditorDisplayName AS NaamLaatsteEditor
FROM dbo.Posts p
WHERE LastEditorDisplayName = 'Rich B' -- mt '', veld is een varchar veld

-- En (met datum) ...
SELECT 
	p.Id			AS PostId,
	p.CreationDate	AS AanmaakDatum,
	p.Score			AS Score,
	p.Title			AS Titel,
	p.Body			AS PostInhoud
FROM dbo.Posts p
WHERE p.CreationDate = '2008-07-31 21:42:52.667' -- mt '', veld CreationDate is datetime veld

-- Licht WHERE filter zonder quotes toe bij bit velden

/* Gebruik (NOT) LIKE in WHERE filters (alleen in nvarchar / varchar velden !!!!) */
SELECT TOP 100
	p.Id					AS PostId,
	p.CreationDate			AS AanmaakDatum,
	p.Score					AS Score,
	p.Title					AS Titel,
	p.Body					AS PostInhoud,
	p.LastEditorDisplayName AS NaamLaatsteEditor
FROM dbo.Posts p
WHERE LastEditorDisplayName LIKE 'Rich%'
-- WHERE LastEditorDisplayName LIKE '%ich%'
-- WHERE LastEditorDisplayName LIKE '%Morgan'
-- WHERE LastEditorDisplayName LIKE '[A-C]%'
-- WHERE LastEditorDisplayName NOT LIKE 'Rich%'



/* Gebruik van meerdere WHERE filters */
-- Met integers
SELECT TOP 100
	p.Id			AS PostId,
	p.CreationDate	AS AanmaakDatum,
	p.Score			AS Score,
	p.Title			AS Titel,
	p.Body			AS PostInhoud
FROM dbo.Posts p
WHERE p.Score > 500 AND p.Score < 1000

-- Met datums
SELECT TOP 100
	p.Id			AS PostId,
	p.CreationDate	AS AanmaakDatum,
	p.Score			AS Score,
	p.Title			AS Titel,
	p.Body			AS PostInhoud
FROM dbo.Posts p
WHERE p.CreationDate >= '2009-01-01' AND p.CreationDate < '2009-01-02'

-- Gecombineerd filter met verschillende velden
SELECT
	p.Id			AS PostId,
	p.CreationDate	AS AanmaakDatum,
	p.Score			AS Score,
	p.Title			AS Titel,
	p.Body			AS PostInhoud
FROM dbo.Posts p
WHERE p.CreationDate >= '2009-01-01' AND p.CreationDate < '2009-01-02'
		AND p.Score > 100

-- Gebruik van OR
SELECT
	p.Id					AS PostId,
	p.CreationDate			AS AanmaakDatum,
	p.Score					AS Score,
	p.Title					AS Titel,
	p.Body					AS PostInhoud,
	p.LastEditorDisplayName AS NaamLaatsteEditor
FROM dbo.Posts p
WHERE p.LastEditorDisplayName = 'Rich B' OR p.LastEditorDisplayName = 'GateKiller'

-- Alternatief met IN functie binnen WHERE filter
SELECT
	p.Id					AS PostId,
	p.CreationDate			AS AanmaakDatum,
	p.Score					AS Score,
	p.Title					AS Titel,
	p.Body					AS PostInhoud,
	p.LastEditorDisplayName AS NaamLaatsteEditor
FROM dbo.Posts p
WHERE p.LastEditorDisplayName IN ('Rich B','GateKiller')
-- WHERE p.Id IN (4,6,7)
/*
Extra stof: 
-----------
WHERE p.Id NOT IN (4,6,7)

Bovenstaand filter zorgt ervoor dat de records met Id 4, 6 of 7
worden uitgesloten; dus juist NIET worden meegenomen!
*/

-- WHERE filter met IS (NOT) NULL 
SELECT TOP 100
	p.Id					AS PostId,
	p.CreationDate			AS AanmaakDatum,
	p.Score					AS Score,
	p.Title					AS Titel,
	p.Body					AS PostInhoud,
	p.LastEditorDisplayName AS NaamLaatsteEditor
FROM dbo.Posts p
WHERE p.LastEditorDisplayName IS NULL
-- WHERE p.LastEditorDisplayName = ''
-- WHERE p.LastEditorDisplayName IS NOT NULL
-- ORDER BY p.LastEditorDisplayName -- sorteren met ORDER BY wordt later behandeld

/* Geavanceerde combinaties met WHERE filter */
SELECT
	p.Id					AS PostId,
	p.CreationDate			AS AanmaakDatum,
	p.Score					AS Score,
	p.Title					AS Titel,
	p.Body					AS PostInhoud,
	p.LastEditorDisplayName AS NaamLaatsteEditor
FROM dbo.Posts p
WHERE 
		p.LastEditorDisplayName IN ('Rich B','GateKiller')
	AND p.CreationDate >= '2008-01-01'
	AND p.CreationDate < '2009-01-01'
	AND p.Score > 100

/* Combineren van AND en OR in WHERE functie (LET OP!) */
SELECT
	p.Id					AS PostId,
	p.CreationDate			AS AanmaakDatum,
	p.Score					AS Score,
	p.LastEditorDisplayName AS NaamLaatsteEditor
FROM dbo.Posts p
WHERE
		p.LastEditorDisplayName IN ('Rich B','GateKiller')
	AND p.Score > 100
	AND 
		p.CreationDate >= '2008-08-01' AND p.CreationDate < '2008-09-01'
	OR	p.CreationDate >= '2008-10-01' AND p.CreationDate < '2008-11-01'
	

/* Sorteren met ORDER BY functie (2 manieren) */
-- Met veldnaam
SELECT TOP 100
	p.Id			AS PostId,
	p.Title			AS Titel,
	p.Score			AS Score,
	p.CreationDate	AS AanmaakDatum,
	p.Body			AS PostInhoud
FROM dbo.Posts p
WHERE p.Score > 500
ORDER BY p.score DESC -- (DESC = Descending = aflopend sorteren!)

-- Met plaats van het veld in de query
SELECT TOP 100
	p.Id			AS PostId,
	p.Title			AS Titel,
	p.Score			AS Score,
	p.CreationDate	AS AanmaakDatum,
	p.Body			AS PostInhoud
FROM dbo.Posts p
WHERE p.Score > 500
ORDER BY 3 -- DESC

/*
Veldaliassen
------------

Dit onderwerp is niet in de instructievideo behandeld. Veldaliassen dienen twee doelen:

1.	Om de naam van de kolom in het query resultaatscherm te wijzigen
	In het voorbeeld wordt het veld Id uit de tabel dbo.Posts in het resultaat als PostId weergegeven

2.	Om het doelveld te benoemen
	Dit wordt niet in de training basisvaardigheden SQL Query's schrijven behandeld, maar is handig
	om te weten. Wanneer de data uit een tabel naar een andere tabel met een andere kolomnaam wordt
	weggeschreven, wordt ook een kolom alias gebruikt.

	Voorbeeld:
	In de tabel dbo.Posts wordt het veld Id gebruikt. Wanneer deze data wordt weggeschreven naar
	een andere tabel waarin hetzelfde veld de naam 'PostId' heeft, wordt in de query bij het 
	ophalen van de data 'AS PostId' gebruikt om aan te geven dat de waarden uit dit veld naar het
	veld PostId in de doeltabel wordt weggeschreven
*/

